//
//  AHKLightMail.m
//  AH-K3001V Utilities
//
//  Created by FUJIDANA on Sun Apr 24 2005.
//  Copyright (c) 2005 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.//
//

#import "AHKMail.h"

static NSString *user_phone_number = @"07000000000";

@implementation AHKLightMail

+ (NSString *)usersPhoneNumber
{
	return user_phone_number;
}

+ (void)setUsersPhoneNumber:(NSString *)value
{
	if (user_phone_number != value) {
		[user_phone_number release];
		user_phone_number = [value copy];
	}
}

- (id)initWithData:(NSData *)datum box:(int)aBox number:(int)aNumber status:(int)aStatus isSecured:(BOOL)flag object:(NSString *)anObject dateString:(NSString *)aDateString
{
	self = [super initWithData:datum
						   box:aBox
						number:aNumber
						status:aStatus
					 isSecured:flag];
	if (self != nil) {
		[self setObject:anObject];
		
		NSArray *components = [aDateString componentsSeparatedByString:@"/"];
		if ([components	count] == 5) {
			aDateString = [NSString stringWithFormat:@"%@-%@-%@ %@-%@-00 +0900",
				[components objectAtIndex:0],
				[components objectAtIndex:1],
				[components objectAtIndex:2],
				[components objectAtIndex:3],
				[components objectAtIndex:4]];
			[self setDate:[NSDate dateWithString:aDateString]];
		} else {
			[self setDate:[NSDate dateWithTimeIntervalSinceNow:0]];
		}
	}
	return self;
}

#pragma mark implements NSCoding
- (id)initWithCoder:(NSCoder *)coder
{
	// if the superclass supports NSCoding protocol, use [super initWithCoder:coder].
	// else, use superclass's designated initializer.
	self = [super initWithCoder:coder];
	
	if ([coder decodeObjectForKey:@"object"]) {
		[self setObject:[coder decodeObjectForKey:@"object"]];
	} else if ([coder decodeObjectForKey:@"from"]) {
		[self setObject:[coder decodeObjectForKey:@"from"]];
	}
	[self setDate:[coder decodeObjectForKey:@"date"]];
	
	return self;
}

- (void)encodeWithCoder:(NSCoder *)coder
{
	[super encodeWithCoder:coder]; // if super class supports NSCoding protocol
	
	[coder encodeObject:object forKey:@"object"];
	[coder encodeObject:date forKey:@"date"];
}

#pragma mark accessor methods
- (NSString *)object
{
	return object;
}
- (void)setObject:(NSString *)value
{
	if (object != value) {
		[object release];
		object = [value copy];
	}
}

- (NSDate *)date
{
	return date;
}
- (void)setDate:(NSDate *)value
{
	if (date != value) {
		[date release];
		date = [value copy];
	}
}

#pragma mark implements AHKMailing
- (NSString *)from
{
	if ([self box] == AHKInboxMailBox) {
		return [self object];
	} else {
		return [[self class] usersPhoneNumber];
	}
}

- (NSString *)to
{
	if ([self box] == AHKInboxMailBox) {
		return [[self class] usersPhoneNumber];
	} else {
		return [self object];
	}
}

- (NSData *)message
{
	NSString *string = [NSString stringWithFormat:@"Date: %@\r\nFrom: %@\r\nTo: %@\r\n\r\n%@\r\n", 
		[[self date] descriptionWithCalendarFormat:@"%a %d %b %Y %H:%M:%S %z" timeZone:nil locale:nil],
		[self from],
		[self to],
		[self body]];
	return [string dataUsingEncoding:NSShiftJISStringEncoding
				allowLossyConversion:YES];
}

- (NSString *)subject
{
	return [self body];
}

- (NSString *)body
{
	return [[[NSString alloc] initWithData:[self data] encoding:NSShiftJISStringEncoding] autorelease];
}


@end
